function DataSetPlotNoise(DataSet, net, MarkerSize, N);

% train the network with noise added to input data and plot the outputs in 2D
% DS - data set
% net - network in the Netlab format
% N - repeat trainig N times
%

for i=1:N
% [xt, yt, DS.Inputs, DS.Desired] = DataSetSplit(DataSet, 66);
xt = AddNoise(DataSet.Inputs);
%   xt = AddNoise(xt);
   
   switch net.type 
      case 'rbf'
%		   net = rbftrain(net, net.options, xt, yt);
   	   [DataSet.Outputs,g,n2] = rbffwd(net,xt);
		case 'mlp'
%			[net, options] = netopt(net, net.options, xt, yt, 'scg');
			DataSet.Outputs = mlpfwd(net, xt);      
		otherwise
			error('not supported type of net'); 
   end

% DataSetPlot(DataSet, 'MarkerSize', MarkerSize);

% Plot the data 2D
%

[NN,C] = size(DataSet.Outputs);

% Specify colors and marker types
colors = [ '+r'; '.g'; 'xb'; '.m'; '.c';'^k'];

  if C == 2
	y_2D = DataSet.Outputs;
  else
       [W, B] = Projection2D(C);   
       y_2D = (W * (DataSet.Outputs'))' + ones(NN,1)*B';
  end

axis([-0.1 1.1 -0.3 1.1]);

for ii=1:NN
   for c=1:C
      if DataSet.Desired(ii,c) == 1
         break
      end
   end
plot(y_2D(i,1),y_2D(i,2), colors(c,:), 'MarkerSize', MarkerSize);
hold on
end

end