
function [x, y, xs, ys, r] = PolygonPoints(n)

% define vertices (x,y) of a regular polygon with a unit side length 
% First vertex is in the (0,0) point
% (xs,ys) - center of the polygon
% r - radius of the circle around the polygon
%

a = 2*pi/n;
b = pi/2-a/2;

r = 1/(2*cos(b));
xs = 1/2;
ys = tan(b)/2;

t = -pi/2-a/2 : a : 2*pi - pi/2 - a;
x = xs + r*cos(t);
y = ys + r*sin(t);


   