function [W, B] = Projection2D(N);

% calculate the transformation matrix from N to 2 dimensions
%

[x,y,xs,ys] = PolygonPoints(N);

P = [x, y, xs, ys];

A = eye(2*N);
A(:,end+1) = [ ones(N,1); zeros(N,1) ];
A(:,end+1) = [ zeros(N,1); ones(N,1) ];
A(end+1,:) = [ ones(N,1); zeros(N,1); 1; 0 ]';
A(end+1,:) = [ zeros(N,1); ones(N,1); 0; 1 ]';

X = (inv(A)*(P'))';

W(1,:) = X(1:N);
W(2,:) = X(N+1:2*N);
B = X(2*N+1:end)';


