clear
clc

iInput = 3;
iHidden = 2;
iOut = 2;

DS = DataSetLoad('..\data\lorentz.dat', iInput);

net = rbf(iInput, iHidden, iOut, 'gaussian');
options = foptions;
options(1) = 0;		% Display EM training
options(14) = 10;	   % number of iterations of EM (default 100)
net.options = options;

[xt, yt, DS_test.Inputs, DS_test.Desired] = DataSetSplit(DS, 66);
net = rbftrain(net, net.options, xt, yt);

[DS_test.Outputs,g,n2] = rbffwd(net,DS_test.Inputs);
[e, p] = CheckErrors(DS_test.Outputs, DS_test.Desired);
%DataSetPlot(DS_test,10);

DataSetPlotNoise(DS, net, 8, 3);