//---------------------------------------------------------------------------

#include <vcl.h>


/*
#include <stdio.h>
#include <stdlib.h>
*/
#include <conio.h>
#include <io.h>
#include <iostream.h>
#include <DateUtils.hpp>
#include "nic_all.h"
#pragma hdrstop




//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char* argv[])
  {
  DecimalSeparator='.';
  cout << "Classical Multidimensional Scaling" << endl;

  if ((argc > 3) && (access(argv[1],0) == 0) &&
      ((access(argv[2],2) == 0) || (access(argv[2],0) != 0)))
    {
    TDateTime t1=Now();

    DataFile MDdata, destination;
    CMDS cs(MDdata, destination);

    cout << "Processing " << argv[1];
    cs.pMDfile()->LoadFile(argv[1]);

    unsigned int iterations=StrToInt(argv[3]);
    bool FullPrecisionEigensystem=false;
    bool Dist=false;
    if (((argc > 4) && (strcmp(argv[4],"full")==0)) || ((argc > 5) && (strcmp(argv[5],"full")==0)))
      {
      FullPrecisionEigensystem=true;
      cout << endl << "Full Precision Eigensystem mode with maximum of "<< iterations << " iterations";
      }
    if (((argc > 4) && (strcmp(argv[4],"dist")==0)) || ((argc > 5) && (strcmp(argv[5],"dist")==0)))
      {
      if (cs.pMDfile()->rData().nrows()==cs.pMDfile()->rData().ncols())
        {
        Dist=true;
        cout << endl << "Treating input data as distances";
        }
      }
    cout << endl << "Calculating...";

    double Accuracy=cs.ClassicalScaling(FullPrecisionEigensystem,iterations,Dist);

    cout << endl << "Saving file " << argv[2];
    cs.pOUTfile()->SaveFile(argv[2]);

    cout << endl << "Accuracy = ";
    cout << FloatToStrF(Accuracy,ffExponent,4,2).c_str();
    cout << endl << "Finished in " << FloatToStrF(MilliSecondsBetween(Now(),t1)/1000.0,ffFixed,15,3).c_str() << " seconds";
    cout << endl << "Complete!" << endl;
    }
    else
      {
      cout << "USAGE:" << endl;
      cout << "  classical.exe MDdata destination nr_of_iterations [options]" << endl;
      cout << "    list of options:" << endl;
      cout << "    full - Enables Full Precision Eigensystem Mode" << endl;
      cout << "    dist - Treat input data as distances between objects" << endl;
      }

  //cout << endl << "Done" << endl;
  //getch();
  return 0;
  }
//---------------------------------------------------------------------------
 