#ifndef _FILE_CLASS_H_
#define _FILE_CLASS_H_

#include "matrix.h"
#include "file_struct.h"
#include <vcl.h>
#include <grids.hpp>
#include <iostream.h>

class DataFile
  {
  private:
  //wskaznik do naglowka
  sec_list parameters;
  unsigned int nobjects;
  //tablica z etykietkami
  AnsiString *obj_classes;
  Matrix *data;
  AnsiString filename;

  //sprawdza czy w naglowku istnieje sekcja
  sec_list SecExists(AnsiString name) const;
  //sprawdza czy w sekcji istnieje wpis
  reg_list RegExists(reg_list section, AnsiString name) const;

  //analiza i wczytywanie pliku
  AnsiString ReadSecName(ifstream &fin);
  AnsiString ReadRegName(ifstream &fin);
  AnsiString ReadRegValue(ifstream &fin);
  AnsiString ReadComment(ifstream &fin);
  AnsiString ReadToEOL(ifstream &fin);
  AnsiString ReadClass(ifstream &fin, AnsiString separator);
  double ReadValue(ifstream &fin, AnsiString separator, AnsiString missing_value);
  AnsiString ReadValueStr(ifstream &fin, AnsiString separator, AnsiString missing_value);
  
  public:
  DataFile();
  DataFile(AnsiString filename);
  DataFile(const DataFile & input_file, const Matrix & output_matrix);
  ~DataFile();

  //zwraca referencje do danych
  Matrix & rData();
  //zwraca wskaznik do danych
  Matrix * pData();
  //zwraca wskaznik do etykiet
  AnsiString * rClasses();

  //czysci obiekt
  void Clear();

  //laczy naglowek z innymi danymi
  void Combine(const DataFile & input_file, const Matrix & output_matrix);
  //wstawia mowe opisy wymiarow
  void ReplaceFeaturesNames();
  //dodaje komentarze do naglowka pliku
  void AddComment(AnsiString comment);

  //dodaje nowa sekcja do naglowka
  sec_list AddSection(AnsiString sec_name);
  //wypisuje naglowek na obiekt klasy TMemo
  void PrintSections(TMemo *memo);

  //dodaje wpisy do sekcji
  reg_list AddRegistry(sec_list section, AnsiString reg_name, AnsiString reg_value);
  reg_list AddRegistry(AnsiString section, AnsiString reg_name, AnsiString reg_value);
  //wypisuje sekcje
  void PrintRegister(sec_list section, TMemo *memo);
  void PrintSection(AnsiString section_name, TMemo *memo);
  //wypisuje sekcje FEATURES do arkusza
  unsigned int PrintFeatures(TStringGrid *tsg);

  //kasuje wpisy w sekcji
  void DelRegister(sec_list section);
  //kasuje naglowek
  void DelSections();

  //zwraca wartosc wpisu
  AnsiString RegValue(AnsiString section, AnsiString registry);
  //zwraca nazwe klasy dla numeru obiektu
  AnsiString ObjectClassName(unsigned int object_number);

  void LoadFile(AnsiString filename);
  void SaveFile(AnsiString filename);

  

  };

#endif
