using System;
using System.Collections.Generic;
using System.Text;

namespace Intemi
{
    public class RulesConfig : IConfiguration
    {
        public IClassificationRules rules;
        public void Configure(ConfigBuilder confBuilder)
        {
            confBuilder.DeclareOutput("Rules", "Rules",
                new Type[] { typeof(IClassificationRules) });
        }
        public object Clone() 
        { 
            RulesConfig res = new RulesConfig();
            res.rules = rules;
            return res;
        }
    }
    [Machine("Rules",typeof(RulesConfig))]
    public class RulesM : IMachine
    {
        IMachineBase machineBase;

        public IClassificationRules Rules
        {
            get { return (machineBase.ConfBase.Configuration as RulesConfig).rules; }
        }
        public void SetMachineBase(IMachineBase mb) { machineBase = mb; }
        public void Run(ref bool shouldTerminate) 
        {
        }
    }
}
