//---------------------------------------------------------------------------
//#include <vcl.h>
#pragma hdrstop
#pragma package(smart_init)
#if !defined (__mDaneH)
    #include "mDane.h"
#endif
//---------------------------------------------------------------------------
//Funkcje prywatne
//---------------------------------------------------------------------------
//x==wiersze
//y==kolumny
void mDane::checkXY(int& x,int& y) const
    {
    if (x<0 || x>=lrow)
        {
        x=0;
        throw ("W mDane wsprzdna x wysza poza zakres");
        }
    if (y<0 || y>=lcol)
        {
        y=0;
        throw ("W mDane wsprzdna y wysza poza zakres");
        }
    }
//---------------------------------------------------------------------------
mString** mDane::setUpDane(const int lx,const int ly)
    {
    mString **prt=0;
    int x=ly;
    int y=lx;
    try
      {
      prt=new mString*[x];
      for (int i=0;i<x;i++)
           prt[i]=new mString[y];
      }
    catch (std::bad_alloc)
        {
        throw ("W mDane zabrako pamici");
        }
    return prt;
    }
//---------------------------------------------------------------------------
void mDane::deleteDane(void)
    {
    if (data!=0 && lcol>0)
      {
       for (int i=0;i<lcol;i++)
           delete[] data[i];
      delete[] data;
      data=0;
      }
    else
       data=0;

    if (preferences)
        delete preferences;
    preferences=0;

    }
//---------------------------------------------------------------------------
void mDane::setUpmDane(const int x,const int y)
    {
    if (x>0 && y>0)
        {
        deleteDane();
        lcol=y;
        lrow=x;
        preferences=new mOption();
        preferences->row=x;
        preferences->col=y;
        data=setUpDane(x,y);
        }
    }
//-----------------------------------------------------------------------------
/*
void mDane::deletemDane(void)
    {
    deleteDane();
    lcol=0;
    lrow=0;
    }
*/
//---------------------------------------------------------------------------
//Funkcje publiczne
//---------------------------------------------------------------------------
mDane::mDane()
    {
    data=0;
    lcol=0;
    lrow=0;
    preferences=new mOption();
    }
//---------------------------------------------------------------------------
mDane::~mDane()
    {
    if (data)
        {
        deleteDane();
        data=0;
        }
    if (preferences)
        {
        delete preferences;
        preferences=0;
        }
    }
//---------------------------------------------------------------------------
mDane::mDane(const int x,const int y,const char *str)
    {
    if (x>0 && y>0)
        {
        data=setUpDane(x,y);
        preferences=new mOption();
        preferences->klas=0;
        lcol=y;
        lrow=x;
        preferences->row=x;
        preferences->col=y;
        preferences->klas=lcol-1;
        if (str!=0)
            {
            for (int i=0;i<lcol;i++)
                for (int j=0;j<lrow;j++)
                    data[i][j]=str;
            }
        }
    else
        {
        lcol=0;
        lrow=0;
        data=0;
        preferences=0;
        }
    }
//---------------------------------------------------------------------------
mDane::mDane(const int x,const int y,float** z)
    {
    if (x>0 && y>0)
        {
        data=setUpDane(x,y);
        preferences=new mOption();
        preferences->klas=0;
        lcol=y;
        lrow=x;
        preferences->row=x;
        preferences->col=y;
        preferences->klas=lcol-1;
        if (z!=0)
            {
            for (int i=0;i<lcol;i++)
                for (int j=0;j<lrow;j++)
                    data[i][j]=z[i][j];
            }
        }
    else
        {
        lcol=0;
        lrow=0;
        data=0;
        preferences=0;
        }
    }
//---------------------------------------------------------------------------
mDane::mDane(const int x,const int y,double** z)
    {
    if (x>0 && y>0)
        {
        data=setUpDane(x,y);
        preferences=new mOption();
        preferences->klas=0;
        lcol=y;
        lrow=x;
        preferences->row=x;
        preferences->col=y;
        preferences->klas=lcol-1;
        if (z!=0)
            {
            for (int i=0;i<lcol;i++)
                for (int j=0;j<lrow;j++)
                    data[i][j]=(float)z[i][j];
            }
        }
    else
        {
        lcol=0;
        lrow=0;
        data=0;
        preferences=0;
        }
    }
//---------------------------------------------------------------------------
mDane::mDane(const int x,const int y,long double** z)
    {
    if (x>0 && y>0)
        {
        data=setUpDane(x,y);
        preferences=new mOption();
        preferences->klas=0;
        lcol=y;
        lrow=x;
        preferences->row=x;
        preferences->col=y;
        preferences->klas=lcol-1;
        if (z!=0)
            {
            for (int i=0;i<lcol;i++)
                for (int j=0;j<lrow;j++)
                    data[i][j]=(float)z[i][j];
            }
        }
    else
        {
        lcol=0;
        lrow=0;
        data=0;
        preferences=0;
        }
    }
//---------------------------------------------------------------------------
mDane::mDane(const mDane& k)
    {
    preferences=new mOption(*k.preferences);
    data=setUpDane(k.lrow,k.lcol);
    lcol=k.lcol;
    lrow=k.lrow;
    lFormat=k.lFormat;
    for (int i=0;i<k.lcol;i++)
        for (int j=0;j<k.lrow;j++)
            {
            this->data[i][j]=k.data[i][j];
            }
    }
//---------------------------------------------------------------------------
mDane& mDane::operator=(const mDane& k)
    {
    if (this->data!=0)
        this->deleteDane();
    if (preferences) delete preferences;
    preferences=new mOption(*k.preferences);

    data=setUpDane(k.lrow,k.lcol);

    lcol=k.lcol;
    lrow=k.lrow;
    lFormat=k.lFormat;
    
    for (int i=0;i<k.lcol;i++)
        for (int j=0;j<k.lrow;j++)
            {
            this->data[i][j]=k.data[i][j];
            }
    return *this;
    }
//---------------------------------------------------------------------------
mDane& mDane::operator=(mString** k)
    {
    if (k!=0 && lrow>0 && lcol>0)
      {
      for (int i=0;i<lcol;i++)
          for (int j=0;j<lrow;j++)
              {
              this->data[i][j]=k[j][i];
              }
      }
    return *this;
    }
//---------------------------------------------------------------------------
mDane& mDane::operator=(float** k)
    {
    if (k!=0 && lrow>0 && lcol>0)
      {
      for (int i=0;i<lcol;i++)
          for (int j=0;j<lrow;j++)
              {
              this->data[i][j]=k[j][i];
              }
      }
    return *this;
    }
//---------------------------------------------------------------------------
mDane& mDane::operator=(double** k)
    {
    if (k!=0 && lrow>0 && lcol>0)
      {
      for (int i=0;i<lcol;i++)
          for (int j=0;j<lrow;j++)
              {
              this->data[i][j]=(double)k[j][i];
              }
      }
    return *this;
    }
//---------------------------------------------------------------------------
mDane& mDane::operator=(long double** k)
    {
    if (k!=0 && lrow>0 && lcol>0)
      {
      for (int i=0;i<lcol;i++)
          for (int j=0;j<lrow;j++)
              {
              this->data[i][j]=(double)k[j][i];
              }
      }
    return *this;
    }
//---------------------------------------------------------------------------
void mDane::moveRow(const int x,const int y)
    {
    if (x<0 || y<0) return;
    if (x>=lrow || y>=lrow) return;
    if (data)
        {
        if (y>=x && x!=y)
            {
            if (x==preferences->klas) preferences->klas=y;
            else if (y>=preferences->klas)
              preferences->klas=preferences->klas-1;
            for (int j=0;j<lcol;j++)
              {
              mString zapas=data[j][x];
              for (int i=x;i<y;i++)
                  {
                  data[j][i]=data[j][i+1];
                  }
              data[j][y]=zapas;
              }
            }
        else if(x!=y)
            {
            if (x==preferences->klas) preferences->klas=y;
            else if (x>preferences->klas)
              preferences->klas=preferences->klas+1;
            for (int j=0;j<lcol;j++)
              {
              mString zapas=data[j][x];
              for (int i=x;i>y;i--)
                  {
                  data[j][i]=data[j][i-1];
                  }
              data[j][y]=zapas;
              }
            }
        }
    }
//---------------------------------------------------------------------------
void mDane::moveCol(const int x,const int y)
    {
    if (x<0 || y<0) return;
    if (x>=lcol || y>=lcol) return;
    if (data)
        {
        if (y>=x && x!=y)
            {
            mString *zapas=data[x];
            for (int i=x;i<y;i++)
                {
                data[i]=data[i+1];
                }
            data[y]=zapas;
            }
        else if (x!=y)
            {
            mString *zapas=data[x];
            for (int i=x;i>y;i--)
                {
                data[i]=data[i-1];
                }
            data[y]=zapas;
            }
        }
    }
//---------------------------------------------------------------------------
void mDane::insertCol(const int x,const mDane* y,const bool z)
    {

    if (data && x>=0)
        {
        if (y==0) return;
        if (y->lrow==0 || y->lcol==0 || y->data==0) return;
        if (x<0) return;
        int xx=x,ylcol,ylrow;
        bool normal;

        if (y->lrow>=y->lcol)
            {
            normal=true;
            ylrow=y->lrow;
            ylcol=y->lcol;
            }
        else
            {
            normal=false;
            ylrow=y->lcol;
            ylcol=y->lrow;
            }

        if (xx>lcol) xx=lcol;
        mString** ptr=new mString*[lcol+ylcol];
        if (xx>lcol)
            {
            for (int i=0;i<lcol;i++)
                ptr[i]=data[i];
            data=ptr;
            for (int i=lcol;i<lcol+ylcol;i++)
                data[i]=new mString[lrow];
            for (int i=lcol;i<lcol+ylcol;i++)
                for (int j=0;j<lrow;j++)
            lcol=lcol+ylcol;
            }
        else
            {
            lcol=lcol+ylcol;
            int k=0;
            for (int i=0;i<lcol;i++)
                {
                if (i<xx || i>=xx+ylcol)
                    {
                    ptr[i]=data[k];
                    k++;
                    }
                }
            data=ptr;
            k=0;
            for (int i=xx;i<xx+ylcol;i++)
                {
                data[i]=new mString[lrow];
                for (int j=0;j<lrow;j++)
                    {
                    if (j<ylrow)
                        {
                        if (normal)
                            data[i][j]=y->get(j,k);
                        else
                            data[i][j]=y->get(k,j);
                        }
                    else
                        data[i][j]="brak_danych!";
                    }
                k++;
                }
            }
        preferences->col=lcol;
        }
    }
//---------------------------------------------------------------------------
void mDane::insertRow(const int xx,const mDane* y,const bool z)
    {
    if (data && xx>=0)
        {
        if (y==0) return;
        if (y->lrow==0 || y->lcol==0 || y->data==0) return;
        int x=xx,ylrow,ylcol;
        bool normal;
        if (x>lrow) x=lrow;
        if (y->lrow<=y->lcol)
            {
            normal=true;
            ylrow=y->lrow;
            ylcol=y->lcol;
            }
        else
            {
            normal=false;
            ylrow=y->lcol;
            ylcol=y->lrow;
            }
        mString **wynik;
        wynik=new mString*[lcol];

        lrow=lrow+ylrow;

        for (int i=0;i<lcol;i++)
            wynik[i]=new mString[lrow];
        int k,jj;
        for (int i=0;i<lcol;i++)
            {
            jj=0;k=0;
            for (int j=0;j<lrow;j++)
                {
                if (j<x || j>=x+ylrow)
                    {
                    wynik[i][j]=data[i][jj];
                    jj++;
                    }
                else if (i<ylcol)
                    {
                    if (normal)
                        wynik[i][j]=y->get(k,i);
                    else
                        wynik[i][j]=y->get(i,k);
                    k++;
                    }
                else
                    wynik[i][j]="brak_danych!";
                }
            }
        int storeCol=lcol;
        int storeRow=lrow;
        mOption lpreferences(*preferences);
        deleteDane();
        lcol=storeCol;
        lrow=storeRow;
        preferences=new mOption(lpreferences);
        data=wynik;
        preferences->row=lrow;
        }
    }
//---------------------------------------------------------------------------
void mDane::usuwaj_kol(const int y1,const y2)
    {
    if (data)
      {
      if (y1<0 || y2<0) return;
      if (y1>=lcol || y2>=lcol) return;
      int ly1,ly2,krok;
      if (y1>y2)
        {
        ly1=y2;
        ly2=y1;
        }
      else
        {
        ly1=y1;
        ly2=y2;
        }
      if (ly2==ly1) krok=1;
      else krok=ly2-ly1+1;

      for (int i=ly1;i<ly2+1;i++)
         delete[] data[i];
         
      for (int i=ly2+1;i<lcol;i++)
        data[i-krok]=data[i];

      lcol=lcol-krok;
      preferences->col=lcol;
      if (y2<=preferences->klas)
        preferences->klas-=krok;
      }
    }
//---------------------------------------------------------------------------
void mDane::usuwaj_row(const int x1,const x2)
    {
    if (data)
      {
      int xx=0,yy,yyy,xy;
      if(x2>=x1)
        {
        yy=x2;
        yyy=x1;
        }
      else
        {
        yy=x1;
        yyy=x2;
        }

      this->checkXY(yy,xx);
      this->checkXY(yyy,xx);
      xx=lrow;
      xy=lcol;
      if (lrow-(yy-yyy+1)!=0)
        {
        int k=0,krok=yy-yyy+1;
        mString **wynik=setUpDane(xx-krok,xy);
        for (int i=0;i<lrow;i++)
            {
            if (i<yyy || i>yy)
              {
               for (int j=0;j<lcol;j++)
                  {
                  wynik[j][k]=this->data[j][i];
                  }
              k++;
              }
            }
        mOption lpref(*preferences);
        this->deleteDane();
        this->data=wynik;
        lcol=xy;
        lrow=xx-krok;
        preferences= new mOption(lpref);
        this->preferences->row=xx-krok;
        }
      }

    }
//---------------------------------------------------------------------------
const mString& mDane::get(const int x,const int y) const
    {
    if (data)
      {
      int xx=x,yy=y;
      checkXY(xx,yy);
      return data[yy][xx];
      }
    else return preferences->pytajnik;
    }
//---------------------------------------------------------------------------
const mString mDane::getLine(const int x,const bool mcol,const int y)const
/*mcol->true funkcja zwraca zadany wiersz w przeciwnym wypadku kolumne*/
    {
    mString wynik("\0",500*y);
    if (mcol==true)
      {
      if (data && x<lrow)
        {
        for (int i=0;i<lcol;i++)
          {
          wynik+data[i][x];
          wynik+"\t";
          }
        }
      }
    else
        {
        if (data && x<lcol)
          {
          for (int i=0;i<lrow;i++)
            {
            for (int j=0;j<y;j++)
                {
                wynik+data[x+j][i];
                wynik+"\t";
                }
            if (i+1<lrow)
                wynik+"\n";
            }
          }
        }
    return wynik;
    }
//---------------------------------------------------------------------------
const char* mDane::get_char(const int x,const int y) const
    {
    if (data)
      {
      int xx=x,yy=y;
      checkXY(xx,yy);
      return (const char*)data[yy][xx];
      }
    else return preferences->pytajnik;
    }
//---------------------------------------------------------------------------
void mDane::set(const mString& a,const int x,const int y)
    {
    if (data)
      {
      int xx=x,yy=y;
      checkXY(xx,yy);
      data[yy][xx]=a;
      }
    }
//---------------------------------------------------------------------------
void mDane::set(const char* a,const int x,const int y)
    {
    if (data)
      {
      int xx=x,yy=y;
      checkXY(xx,yy);
      data[yy][xx]=a;
      }
    }
//---------------------------------------------------------------------------
void mDane::set(const int a,const int x,const int y)
    {
    if (data)
      {
      int xx=x,yy=y;
      checkXY(xx,yy);
      data[yy][xx]=a;
      }
    }
//---------------------------------------------------------------------------
void mDane::setLine(const char* str,const int x,const bool lrc,const bool f0,const bool f1)
    {
    /*
    lrc=true->wstawiamy kolumny w przeciwnym wypadku wstawiamy wiersze
    f1=false->wstawiamy cale wiersze/kolumny
    f0=true->zastepujemy istejce wiersze/kolumny
    */
    mString store(str);
    int sp=0;
    int sp0;
    int xx;
    if (x>=0)
      {
      if (lrc==true && x<lcol) xx=x;
      else if (lrc==false && x<lrow) xx=x;
      else xx=0;
      }
    if (f0==true)
        {
        int jj=0;
        while (sp>0)
            {
            sp0=sp;
            sp=store.find(" ",sp0);
            //wstawiamy w kolumny
            if (lrc && xx<lcol)
                {
                data[xx][jj]=store.cut(sp0,sp);
                }
            //wstawiamy w wiersze
            else if (xx<lrow)
                data[jj][xx]=store.cut(sp0,sp);
            else
                sp=-1;

            jj++;
            if (sp>0) sp++;
            sp0=sp;
            }

        if (f1==false)
            {
            if (lrc==true)
            for (int i=jj;i<lcol;i++)
                data[xx][i]="??";
            else
            for (int i=jj;i<lrow;i++)
                data[i][xx]="??";
            }
        }
    else
        {
        if (lrc==true)
            {
            mDane hwstaw(1,lcol);
            int sp0,sp=0;
            for (int i=0;i<lcol;i++)
                {
                sp0=sp;
                if (sp0>=0)
                    {
                    sp=store.find(" ",sp0);
                    char *ch=store.cut(sp0,sp);
                    hwstaw.set(ch,i,0);
                    delete[] ch;
                    if (sp>0) sp++;
                    sp0=sp;
                    }
                else
                    {
                    hwstaw.set("??",i,0);
                    }
                }
            insertCol(xx,&hwstaw);
            }
        else
            {
            mDane hwstaw(lrow,1);
            int sp0,sp=0;
            for (int i=0;i<lrow;i++)
                {
                sp0=sp;
                if (sp0>=0)
                    {
                    sp=store.find(" ",sp0);
                    char *ch=store.cut(sp0,sp);
                    hwstaw.set(ch,0,i);
                    delete[] ch;
                    if (sp>0) sp++;
                    sp0=sp;
                    }
                else
                    {
                    hwstaw.set("??",0,i);
                    }
                }
            insertRow(xx,&hwstaw);
            }
        }
    }
//---------------------------------------------------------------------------
float* mDane::konwersjaf_row(const int kol) const
    {
    int lkol=kol,sum=0,k;
    float **p=new float*[lrow];
    for (int i=0;i<lrow;i++)
        {
        p[i]=data[lkol][i].toFloat();
        }
    for (int i=0;i<lrow;i++)
        sum=sum+p[i][0];
    float *wynik=new float[sum+2];
    k=0;
    wynik[0]=sum+1;
    k++;
    for (int i=0;i<lrow;i++)
        {
        for (int j=1;j<p[i][0]+1;j++)
            {
            wynik[k]=p[i][j];
            k++;
            }
        }
    for (int i=0;i<lrow;i++)
        delete[] p[i];
    delete[]p;
    return wynik;
    }
//-----------------------------------------------------------------------------
float** mDane:: konwersjaf_Dane(void) const
    {
    float **wynik=0;
    if (data!=0)
      {
      float *znak;
      wynik=new float*[preferences->row];
      for (int i=0;i<preferences->row;i++)
          wynik[i]=new float[preferences->col];
      for (int j=0;j<preferences->col;j++)
        for (int i=0;i<preferences->row;i++)
          {
          znak=get(i,j).toFloat();
          if (znak[0]>0)
              wynik[i][j]=znak[1];
          else
              wynik[i][j]=0;
          delete[] znak;
          }
      }
    return wynik;
    }
//-----------------------------------------------------------------------------
float* mDane:: konwersjaf_col(const int j) const
    {
    float *wynik=0;
    if (data!=0)
      {
      float *znak;
      wynik=new float[preferences->row];

      for (int i=0;i<preferences->row;i++)
          {
          znak=get(i,j).toFloat();
          if (znak[0]>0)
              wynik[i]=znak[1];
          else
              wynik[i]=0;
          delete[] znak;
          }
      }
    return wynik;
    }
//-----------------------------------------------------------------------------
void mDane:: standaryzacja1(const int kol)
    {
    int lkol,k=1;
    if (kol<0 || kol>preferences->col)
        lkol=0;
    else lkol=kol;

    float sum=0;
    float *wy=this->konwersjaf_row(lkol);
    for (int i=1;i<wy[0];i++)
         if (wy[i]>sum) sum=wy[i];
    for (int i=0;i<lrow;i++)
        {
        if (data[lkol][i]!=(preferences->pytajnik))
            {
            data[lkol][i]=(wy[k]/sum);
            k++;
            }
        }
    delete[] wy;
}
//-----------------------------------------------------------------------------
void mDane:: standaryzacja2(const int kol,const int par)
    {
    int lkol,k=1;
    if (kol<0 || kol>lcol)
        lkol=0;
    else lkol=kol;
    float sum=0,sred_odch=0;
    float *wy=this->konwersjaf_row(lkol);
    for (int i=1;i<wy[0];i++)
        sum=sum+wy[i];
    sum=sum/(wy[0]-1);
    for (int i=1;i<wy[0];i++)
        sred_odch=sred_odch+((wy[i]-sum)*(wy[i]-sum));
    sred_odch=sred_odch/(wy[0]-2);
    sred_odch=(float)sqrt((double)sred_odch);
    for (int i=0;i<lrow;i++)
        {
        if (data[lkol][i]!=(preferences->pytajnik))
            {
            if (wy[k]<fabs(sum-(par*sred_odch)))
                data[lkol][i]="0";
            else if (wy[k]>(sum+(par*sred_odch)))
                data[lkol][i]="1";
            else
                data[lkol][i]=(wy[k]/(sum+par*sred_odch));
            k++ ;
            }
        }
    delete wy;
    }
//-----------------------------------------------------------------------------
void mDane:: kombinacjaLiniowa(const mDane& x,const bool f1)
    {
    float **m1,**m2,wynik;
    int xcol=lcol,xrow=lrow,krok,krok0;
    mOption lpref(*preferences);
    m1=this->konwersjaf_Dane();
    this->deleteDane();
    m2=x.konwersjaf_Dane();
    if (f1==true)
        {
        krok=0;
        krok0=1;
        }
    else
        {
        krok=1;
        krok0=0;
        }
    mString **wy=setUpDane(xrow,x.preferences->col+krok);

    for (int i=0;i<xrow;i++)
      {
      for (int k2=0;k2<x.preferences->col-krok0;k2++)
        {
        int j=0;
        wynik=0;
        while (j<x.preferences->row && j<xcol-1)
            {
            wynik+=m1[i][j]*m2[j][k2];
            j++;
            }
        wy[k2][i]=wynik;
        }
      }

    for (int i=0;i<xrow;i++)
        wy[x.preferences->col-krok0][i]=m1[i][xcol-1];

    this->data=wy;
    lcol=x.preferences->col+krok;
    lrow=xrow;
    preferences= new mOption(lpref);
    preferences->col=lcol;
    preferences->row=lrow;
    for (int i=0;i<xrow;i++)
        delete[] m1[i];
    delete[] m1;
    for (int i=0;i<x.preferences->row;i++)
        delete[] m2[i];
    delete[] m2;
    }
//-----------------------------------------------------------------------------
void mDane::kombinacjaLiczba(const float x,const int y)
    {
    if (y==-1)
        {
        float **m1=konwersjaf_Dane();
        for (int i=0;i<lrow;i++)
            for (int j=0;j<lcol;j++)
                {
                m1[i][j]=m1[i][j]*x;
                }

        for (int i=0;i<lcol;i++)
            for (int j=0;j<lrow;j++)
                {
                data[i][j]=m1[j][i];
                }

        }
    else
        {
        float *wy=this->konwersjaf_row(y);
        for (int i=0;i<lrow;i++)
            {
            if (i<wy[0])
                data[y][i]=wy[i+1];
            else
                data[y][i]="0";
            }
        }
    }
//-----------------------------------------------------------------------------
void mDane::zamieniaj_symbol(const mString& s1,const mString& s2,const int opcjq,const int kol)
    {
    if (opcjq==1)
        {
        int lkol;
        if (kol<0 || kol>preferences->col)
            lkol=0;
        else lkol=kol;
        for (int i=0;i<lrow;i++)
            {
            if (this->data[lkol][i]==s1)
                this->data[lkol][i]=s2;
            }
        }
    else
        {
        for (int i=0;i<lcol;i++)
            for (int j=0;j<lrow;j++)
                {
                if (this->data[i][j]==s1)
                   this->data[i][j]=s2;
                }
        }
    }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
const bool mDane::wsktest(void) const
    {
    if (data==0)
        return 0;
    else
        return 1;
    }
//-----------------------------------------------------------------------------
void mDane::set_pytajnik(const mString x)
    {
    if (x!="\0")
      {
      preferences->pytajnik=x;
      }
    }
//-----------------------------------------------------------------------------
void mDane::setFormat(const mFormat& x)
    {
    lFormat=x;
    }
//-----------------------------------------------------------------------------
